<?php

require __DIR__ . '/PHPMailer/src/Exception.php';
require __DIR__ . '/PHPMailer/src/PHPMailer.php';
require __DIR__ . '/PHPMailer/src/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

// Leer JSON recibido desde JavaScript
$input = file_get_contents("php://input");
$data = json_decode($input, true);

// Validar datos requeridos
if (
    !$data ||
    !isset($data["folio"]) ||
    !isset($data["userNumber"]) ||
    !isset($data["name"]) ||
    !isset($data["date"]) ||
    !isset($data["sucursal"]) ||
    !isset($data["descripcion"])
) {
    enviarRespuesta(false, "Datos incompletos o JSON inválido.");
}

// Extraer variables
$folio       = $data["folio"];
$userNumber  = $data["userNumber"];
$name        = $data["name"];
$date        = $data["date"];
$sucursal    = $data["sucursal"];
$descripcion = $data["descripcion"];

// Enviar correo
if (enviarCorreo($folio, $userNumber, $name, $date, $sucursal, $descripcion)) {
    enviarRespuesta(true, "Correo enviado correctamente.");
} else {
    enviarRespuesta(false, "No se pudo enviar el correo. Revisa error_log.");
}


/* ============================================================
   FUNCIÓN PARA ENVIAR EL CORREO
   ============================================================ */
function enviarCorreo($folio, $userNumber, $name, $date, $sucursal, $descripcion)
{
    $mail = new PHPMailer(true);

    try {

        // 🔥 Activar debug (revisa error_log)
        $mail->SMTPDebug = 2;
        $mail->Debugoutput = 'error_log';

        $mail->isSMTP();
        $mail->Host = 'mail.cajacerrodelasilla.com.mx';
        $mail->SMTPAuth = true;
        $mail->Username = 'pruebas@cajacerrodelasilla.com.mx';
        $mail->Password = '8@@F_CefrHYC'; // ⚠️ Cambia la contraseña
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = 587;

        $mail->CharSet = 'UTF-8';

        $mail->setFrom('pruebas@cajacerrodelasilla.com.mx', 'Sistema de Tickets');
        $mail->addAddress('adair@cajacerrodelasilla.com.mx');
        //$mail->addAddress('amairani@cajacerrodelasilla.com.mx');
        /*$mail->addAddress('sistemas@cajacerrodelasilla.com.mx');
        $mail->addAddress('sistemas_2@cajacerrodelasilla.com.mx');*/
        $mail->addReplyTo('no-reply@cajacerrodelasilla.com.mx', 'No Responder');

        $mail->isHTML(true);
        $mail->Subject = "Nuevo Ticket - Folio $folio";

        $mail->Body = "
        <html>
            <body style='font-family:Arial;'>
                <h2 style='color:#0275d8;'>Nuevo Ticket Registrado</h2>

                <p><strong>Folio:</strong> $folio</p>
                <p><strong>Número de Usuario:</strong> $userNumber</p>
                <p><strong>Nombre:</strong> $name</p>
                <p><strong>Fecha:</strong> $date</p>
                <p><strong>Sucursal:</strong> $sucursal</p>
                <p><strong>Descripción:</strong></p>
                <p>$descripcion</p>
                <p>http://133.145.4.186/intranet3/solicitudes_respuesta.php?folio=$folio&%20userNumber=$userNumber</p>

                <hr>
                <p style='color:#777;'>Mensaje automático. No responder.</p>
            </body>
        </html>";

        return $mail->send();

    } catch (Exception $e) {
        error_log("Error Mailer: " . $mail->ErrorInfo);
        return false;
    }
}


/* ============================================================
   FUNCIÓN DE RESPUESTA JSON
   ============================================================ */
function enviarRespuesta($success, $message)
{
    echo json_encode([
        "success" => $success,
        "message" => $message
    ]);
    exit();
}
?>
